--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Manila
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "man_marketkeep" }
DefineCharacter { name = "man_farmkeep" }
DefineCharacter { name = "man_otherkeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "manila",
	available = false,
	ambient="sfx/village_loop.ogg", 

	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_03", time=270000, loop=true, htile=true, path={{0,60},{100,60},{700,60},{800,60}}, },
		
		-- Planes
		SpriteLayer { imagelist=portPlanes, time=20000,hold=5000,bounce=true,scale=.25,
			path={{-80,35},{100,35},{750,35},{880,35}} },
			
		-- Ships
		SpriteLayer { imagelist=portBoats, time=245000,hold=10000,bounce=true,scale=.15,
			path={{-80,152},{100,152},{750,152},{880,152}} },
		
		SpriteLayer { image="man_shipmask", x=181+328/2,y=54+129/2 },
		
		Market { name="man_farm", character="man_farmkeep", x=550+250/2,y=66+124/2,
			ambient = "sfx/farm_loop.ogg",
			inventory = { ph_cacao=true}, dialog="farm_manila" },
			
	    -- Clouds foreground
		SpriteLayer { image="clouds_03", time=110000, loop=true,  path={{0,20},{100,20},{700,20},{800,20}}, },
			
		-- Carts
		SpriteLayer { imagelist=portCars, time=7000,hold=10000,bounce=true,scale=.3,
			path={{267,251},{307,234},{447,234},{492,247},}, },
			
		SpriteLayer { image="man_farmmask", x=452+238/2,y=79+179/2 },
		SpriteLayer { image="man_cartmask", x=187+116/2,y=166+98/2 },
		
		EmptyBuilding { name="man_other", character="man_otherkeep", ambient="sfx/other_loop.ogg", x=559+241/2,y=154+144/2 },
		
		Market { name="man_market", character="man_marketkeep", x=0+232/2,y=85+337/2,
			inventory = { sugar=true, cashew=true, cacao=true, mango=true, coffee=true, milk=true } },
			
		-- Cars
		SpriteLayer { image="car_07", farscale=.35,far=250,nearscale=2,near=600,
			path={{-69,486},{84,398},{244,317},{306,278},}, },
		
		SpriteLayer { image="man_pole", x=231+6/2,y=237+161/2 },

		-- Bobbing canoe
		SpriteLayer { image="boat_06", scale=.8, time=15000,hold=8000,
			path={{515,461},{525,382},{605,386},{872,408},}, },
	}
}
